<Grid xmlns="http://schemas.microsoft.com/winfx/2006/xaml/presentation" xmlns:System="clr-namespace:System;assembly=mscorlib"
                                xmlns:local="clr-namespace:DataservWPFInterfaces;assembly=DataservWPFInterfaces" xmlns:x="http://schemas.microsoft.com/winfx/2006/xaml" x:Name="RecipeForm" KeyboardNavigation.TabNavigation="Cycle">

       <!-- jgamble this Is where we define the look And feel settings for all the auto-generated fields, code reuse in wpf :pfft: -->
       <Grid.Resources>
            <Thickness x:Key="controlPad">3,0,3,0</Thickness>
            <Thickness x:Key="textboxPad">3,1,3,1</Thickness>
            <GridLength x:Key="GridPad">4</GridLength>
            <Style TargetType="StackPanel" x:Key="PresetStackPanelStyle">
                <Style.Resources>
                    <Style TargetType="StackPanel">
                        <Setter Property="Margin" Value="{DynamicResource controlPad}"/>
                    </Style>
                    <Style TargetType="{x:Type TextBox}" >
                        <Setter Property="Margin" Value="{DynamicResource textboxPad}"/>
                        <Setter Property="TextAlignment" Value="Center" />
                        <Setter Property="FontSize" Value="16" />
                        <Setter Property="FontWeight" Value="Bold" />
                        <Setter Property="Padding" Value="2" />
                        <Setter Property="MaxWidth" Value="225" />
                    </Style>
                    <Style TargetType="{x:Type ComboBox}" >
                        <Setter Property="Margin" Value="{DynamicResource textboxPad}" />
                        <Setter Property="HorizontalContentAlignment" Value="Center" />
                        <Setter Property="FontSize" Value="16" />
                        <Setter Property="FontWeight" Value="Bold" />
                        <Setter Property="Padding" Value="2" />
                        <Setter Property="MaxWidth" Value="225" />
                    </Style>
                    <Style TargetType="{x:Type Label}" x:Key="LabelStyle1">
                        <Setter Property="Margin" Value="{StaticResource controlPad}"/>
                        <Setter Property="HorizontalAlignment" Value="Center"/>
                    </Style>
                    <Style TargetType="Label" x:Key="LabelStyle2" BasedOn="{StaticResource LabelStyle1}">
                        <Setter Property="FontSize" Value="16"/>
                        <Setter Property="FontWeight" Value="Bold"/>
                    </Style>
                    <Style TargetType="{x:Type Label}" BasedOn="{StaticResource LabelStyle1}"/>
                </Style.Resources>
            </Style>

                    <Style TargetType="Border" x:Key="StackPanelBorder">
                        <Setter Property="BorderBrush" Value="DarkGray" />
			             <Setter Property="CornerRadius" Value="2,2,2,2" />
			             <Setter Property="BorderThickness" Value="2,2,2,2" />
                    </Style>

        </Grid.Resources>
        <!--Loading Animation Control-->
        <local:AdornedControl x:Name="AdoredLoader" IsAdornerVisible="False">
            <local:AdornedControl.AdornerContent>
                <Grid x:Name="OverlayGrid" Opacity=".7" Background="Gainsboro">
                    <local:LoadingAnimation x:Name="WaitWheel" Height="200" Width="200" WaitingMessage="Loading"></local:LoadingAnimation>
                </Grid>
            </local:AdornedControl.AdornerContent>
        </local:AdornedControl>
        <!--"No Recipe" Overlay Message, Should Be Rolled Into "Messagbox" overlay when that's working properly-->
        <local:AdornedControl x:Name="NoRecipeOverlay" IsAdornerVisible="False">
            <local:AdornedControl.AdornerContent>
                <Grid Margin="0,20,0,0" Background="Gainsboro">
                    <TextBlock Width="350" Height="200" TextWrapping="Wrap" Text="There are currently no recipes, use the 'Recipe --> New' menu item to create a new one." FontWeight="Bold" FontSize="24" />
                </Grid>
            </local:AdornedControl.AdornerContent>
        </local:AdornedControl>
        <!--"Message box" Overlay Control, The way the HMI Implements this, message boxes are sometimes not "Top Level", causing them to lock the application-->
        <local:AdornedControl x:Name="MessageBox" IsAdornerVisible="False">
            <local:AdornedControl.AdornerContent>
                <Grid Margin="5,5,5,5" HorizontalAlignment="Center" VerticalAlignment="Center">
                    <Border Name="outerborder" CornerRadius="5" BorderBrush="DarkGray" BorderThickness="3,3,0,0" >
                        <Border Name="innerborder"  CornerRadius="5" BorderBrush="Black" BorderThickness="0,0,3,3">
                            <StackPanel Orientation="Vertical" Background="Gainsboro" HorizontalAlignment="Center" VerticalAlignment="Center" >
                                <Border  Name="mask"  CornerRadius="1" BorderBrush="White" BorderThickness="1,1,2,1" >
                                    <Label x:Name="MessagboxPaneTitle" Foreground="White" Content="Do Something?" Padding="5" FontWeight="Bold" RenderTransformOrigin="0.5,0.5">
                                        <Label.Background>
                                            <LinearGradientBrush EndPoint="0.8,0.2" StartPoint="0.2,1" SpreadMethod="Reflect">
                                                <LinearGradientBrush.RelativeTransform>                                                    <TransformGroup>
                                                        <ScaleTransform CenterY="0.5" CenterX="0.5" ScaleY="1" ScaleX="1"/>
                                                        <SkewTransform AngleY="0" AngleX="3" CenterY="0.5" CenterX="0.5"/>
                                                        <RotateTransform Angle="357.879" CenterY="0.5" CenterX="0.5"/>
                                                    </TransformGroup>
                                                </LinearGradientBrush.RelativeTransform>
                                                <GradientStop Color="#FF6F6C8F" Offset="0.713"/>
                                                <GradientStop Color="#FF1910DE" Offset="0.14"/>
                                            </LinearGradientBrush>
                                        </Label.Background>
                                    </Label>
                                </Border>
                                <ScrollViewer Width="350" MaxHeight="500">
                                    <TextBlock Padding="5" HorizontalAlignment="Center" x:Name="AlertMessage" Width="350" TextWrapping="Wrap" Text="This is a label." FontWeight="Bold" FontSize="14" />
                                </ScrollViewer>
                                <StackPanel Orientation="Vertical" HorizontalAlignment="Center" Margin="0,5,0,5">
                                    <TextBox x:Name="txtMessageBoxInput" Width="250" Text="" Visibility="Hidden"/>
                                    <StackPanel Orientation="Horizontal" HorizontalAlignment="Center" Margin="0,5,0,5">
                                        <Button x:Name="OKButt" Width="75" Content="OK" />
                                        <Button  Width="75" x:Name="YesButt" Content="Yes" />
                                        <Label Content="   "  Width="25" />
                                        <Button  Width="75" x:Name="NoButt" Content="No" />
                                    </StackPanel>
                                </StackPanel>
                            </StackPanel>
                        </Border>
                    </Border>
                </Grid>
            </local:AdornedControl.AdornerContent>
        </local:AdornedControl>
            <!-- if you want to have a tab panel for wrap it around this scroll viewer, probably -->
            <ScrollViewer VerticalScrollBarVisibility="Auto" Margin="250,60,0,55" MaxHeight="550" VerticalAlignment="Top" >
		<Grid Margin="0,0,6,0">
                    <Grid.ColumnDefinitions>
                        <ColumnDefinition Width="1*" MinWidth="240"/>
                        <ColumnDefinition Width="{StaticResource GridPad}" />
                        <ColumnDefinition Width="1*" MinWidth="240"/>
                    </Grid.ColumnDefinitions>
                    <Grid.RowDefinitions>
                        <RowDefinition Height="Auto"/>
                        <RowDefinition Height="{StaticResource GridPad}" /> 
                        <RowDefinition Height="Auto"/>

                    </Grid.RowDefinitions>
					 <Border Style="{StaticResource StackPanelBorder}" Grid.Row="0" Grid.Column="0" Grid.ColumnSpan="3">
                       <StackPanel Background="LightGray" Style="{DynamicResource PresetStackPanelStyle}">
                           <Label Content="Model Number" Style="{DynamicResource ResourceKey=LabelStyle2}"/>
                           <TextBox  x:Name="ModelNumber" MaxWidth="480"  />
                           <Label Content="Model Description" />
                           <TextBox x:Name="ModelDesc" TextWrapping="Wrap" Height="50" MaxWidth="480"/>
                       </StackPanel>
					 </Border>
</Grid>
            </ScrollViewer>


        <Label HorizontalContentAlignment="Center"  Content="Recipe Configuration" HorizontalAlignment="Left" Height="38" Margin="246,29,0,0" VerticalAlignment="Top" Width="513" FontWeight="Bold" FontSize="16" />

        <ListBox x:Name="lstRecipes" HorizontalAlignment="Left" Height="393" Margin="6,58,0,0" VerticalAlignment="Top" Width="235" BorderThickness="3,3,2,2" BorderBrush="DarkGray">
            <ListBox.ContextMenu>
                <ContextMenu x:Name="lstRecipesMenuContext">
                    <MenuItem Header="_New" x:Name="NewRecipeMenuItemContext"></MenuItem>
                    <MenuItem Header="_Copy" x:Name="CopyRecipeMenuItemContext"/>
                    <MenuItem Header="_Delete" x:Name="DeleteRecipeMenuItemContext"></MenuItem>
                    <MenuItem Header="Set _Global Preset" x:Name="GlobalPresetRecipeItemContext"></MenuItem>
                    <MenuItem Header="_Update Several Models" x:Name="UpdateMultipleRecipeItemContext"/>
                </ContextMenu>
            </ListBox.ContextMenu>
        </ListBox>

        <TextBox IsTabStop="False" HorizontalAlignment="Left" VerticalAlignment="Top" x:Name="txtSearch" Height="23" TextWrapping="Wrap" Margin="85,469,0,0" Width="134"/>
        <Button IsTabStop="False" x:Name="cmdSearch" Content="Search" Width="72" Height="23" VerticalAlignment="Top" HorizontalAlignment="Left" Margin="8,469,0,0"/>
        <Button IsTabStop="False" x:Name="cmdClearSearch" Content="X" Width="17"  VerticalAlignment="Top" HorizontalAlignment="Left" Margin="224,469,0,0" Height="23" FontWeight="Bold" Foreground="#FFF90218"/>
        <Label IsTabStop="False" HorizontalContentAlignment="Center"  Content="Available Recipes" HorizontalAlignment="Left" Height="38" Margin="38,29,0,0" VerticalAlignment="Top" Width="168" FontWeight="Bold" FontSize="16" />
        <Button IsTabStop="False" x:Name="cmdSave" Content="Save" HorizontalAlignment="Left" Margin="178,504,0,0" VerticalAlignment="Top" Width="63" RenderTransformOrigin="-0.147,0.95" Height="23"  />
        <Button IsTabStop="False" x:Name="cmdAbortMulti" Content="Exit Multi-Update" HorizontalAlignment="Left" Margin="55,530,0,0" VerticalAlignment="Top" Width="132" Visibility="Hidden" Height="23" />

        <Button IsTabStop="False" x:Name="cmdPrevious" Content="&lt;" RenderTransformOrigin="-0.147,0.95" Height="23" VerticalAlignment="Top" HorizontalAlignment="Left" Width="33" Margin="7,504,0,0" />
        <TextBox IsTabStop="False" x:Name="txtCurrentDataPosition" HorizontalAlignment="Left" TextWrapping="Wrap" Width="97" RenderTransformOrigin="2.632,-6.174" Height="23" VerticalAlignment="Top" Margin="40,504,0,0" />
        <Button IsTabStop="False" x:Name="cmdNext" Content="&gt;" HorizontalAlignment="Left" VerticalAlignment="Top" Width="33" RenderTransformOrigin="-0.147,0.95" Height="23" Margin="139,504,0,0" />

        <Menu IsMainMenu="True" Margin="0,0,0,0" Height="20" VerticalAlignment="Top" IsTabStop="False" TabIndex="1000">
            <MenuItem Header="_Recipe">
                <MenuItem Header="_New" x:Name="NewRecipeMenuItem"/>
                <MenuItem Header="_Copy" x:Name="CopyRecipeMenuItem"/>
                <MenuItem Header="_Delete" x:Name="DeleteRecipeMenuItem"/>
                <MenuItem Header="Set _Global Preset" x:Name="GlobalPresetRecipeItem"/>
                <MenuItem Header="_Update Several Models" x:Name="UpdateMultipleRecipeItem"/>
            </MenuItem>
        </Menu>
    </Grid>